/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.common.crafting.fluidontop.FluidOnTopRecipe;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class FluidOnTopRegistry {
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    @Nonnull
    private final List<FluidOnTopRecipe> recipeList = new ArrayList<FluidOnTopRecipe>();
    @Nonnull
    private final Item empty = ItemStack.f_41583_.m_41720_();
    @Nonnull
    private final Map<FluidStack, Map<FluidStack, Item>> itemResultCache = new HashMap<FluidStack, Map<FluidStack, Item>>();

    public boolean isValidRecipe(@Nonnull Fluid fluidInTank, @Nonnull Fluid fluidOnTop) {
        return this.getResultItem(fluidInTank, fluidOnTop) != this.empty;
    }

    @Nonnull
    private Item getResultItem(@Nonnull Fluid fluidInTank, @Nonnull Fluid fluidOnTop) {
        return this.itemResultCache.computeIfAbsent(new FluidStack(fluidInTank, 1000), k -> new HashMap()).computeIfAbsent(new FluidStack(fluidOnTop, 1000), k -> this.recipeList.stream().filter(fluidOnTopRecipe -> fluidOnTopRecipe.validInputs(fluidInTank, fluidOnTop)).findFirst().map(FluidOnTopRecipe::m_8043_).map(ItemStack::m_41720_).orElse(this.empty));
    }

    @Nonnull
    public ItemStack getResult(@Nonnull Fluid fluidInTank, @Nonnull Fluid fluidOnTop) {
        return new ItemStack((ItemLike)this.getResultItem(fluidInTank, fluidOnTop));
    }

    @Nonnull
    public List<FluidOnTopRecipe> getRecipeList() {
        return this.recipeList;
    }

    public void setRecipes(@Nonnull List<FluidOnTopRecipe> recipes) {
        logger.debug("Fluid On Top Registry recipes: " + recipes.size());
        this.recipeList.addAll(recipes);
        this.itemResultCache.clear();
    }

    public void clearRecipes() {
        this.recipeList.clear();
        this.itemResultCache.clear();
    }
}

